// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef GP_INTERNAL_H
#define GP_INTERNAL_H

#include "degub.h"
#include "hw_internal.h"
#include "gp.h"

#define TROGDOR "TROGDOR the BURNiNATOR"

#define GPHR_CONDITION (true)//(!(g::dual_run && g::recompiler))  //is this right?
#define GPHR(func) HWHR(func)//if(GPHR_CONDITION) { /*VGPDEGUB("%i: %s\n", __LINE__, #func);*/ HWHR(func) }
#define GPGLE(func) /*if(GPHR_CONDITION)*/ HWGLE(func)

#define GP_QUEUE_GET_NOSWAP(type) (*(const type*)queue_get_data(sizeof(type)))
#define GP_QUEUE_GET_DWORD swapw(GP_QUEUE_GET_NOSWAP(DWORD))
#define GP_QUEUE_GET_WORD swaph(GP_QUEUE_GET_NOSWAP(WORD))
#define GP_QUEUE_GET_BYTE GP_QUEUE_GET_NOSWAP(BYTE)

#define GP_QUEUE_GET_BP_REG queue_get_past_byte(4)

#define GP_BP_TX_DECLARE_INDEX const BYTE regnum = GP_QUEUE_GET_BP_REG;\
	const BYTE index = (regnum & 3) | ((regnum & 0x20) >> 3);\
	MYASSERT(index < 8)
#define GP_BP_TEV_DECLARE_INDEX const BYTE regnum = GP_QUEUE_GET_BP_REG;\
	const BYTE index = ((regnum & 0x1E) >> 1);\
	MYASSERT(index < 16)

void dump_matrix(const D3DMATRIX *m);

union BPLOAD {
	struct {
		DWORD data : 24;
		DWORD reg : 8;
	};
	DWORD dword;
};

struct CONVERTICES {
	LPDIRECT3DVERTEXBUFFER9 vertexBuffer;
	DWORD FVF;
	WORD midx;
	BYTE convertexSize;
};

//vertex decoding helpers
const char *gp_get_coord_size_string(int fmt);
int gp_get_coord_size(int fmt);
const char *gp_get_norm_size_string(int fmt);
int gp_get_norm_size(int fmt);
const char *gp_get_color_string(int fmt);
int gp_get_color_size(int fmt);
const char *gp_get_enc_string(int fmt);
DWORD gp_argb8_rgba4(WORD rgba4);
DWORD gp_argb8_rgba6(DWORD rgba6);
DWORD gp_argb8_rgb565(WORD rgb565);

struct TEX_VCD {
	int enc;
	int fmt;
	bool cnt; //false = 1, true = 2.
	int shift;
};
struct TEX_VCD_INPUT_BASE {
	BYTE reg;
	int start;
};
static const TEX_VCD_INPUT_BASE tvib_two_fmt[8] = { {0x70,21},{0x80,0},{0x80,9},
{0x80,18},{0x80,27},{0x90,5},{0x90,14},{0x90,23} };
static const TEX_VCD_INPUT_BASE tvib_shift[8] = { {0x70,25},{0x80,4},{0x80,13},
{0x80,22},{0x90,0},{0x90,9},{0x90,18},{0x90,27} };

//#define ZMAX 16777215.0f
#define ZMAX ((float)0xFFFFFF)

//conversion functions and macros
inline D3DCOLORVALUE byte2cv(BYTE r, BYTE g, BYTE b, BYTE a) {
	D3DCOLORVALUE cv = { r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f };
	return cv;
}
inline D3DCOLORVALUE dword2cv(DWORD d) {
	return byte2cv(BYTE(d >> 24), BYTE(d >> 16), BYTE(d >> 8), BYTE(d));
}
#define THREE_TO_8BIT(three) (((three) << 5) | ((three) << 2) | ((three) >> 1))
#define FOUR_TO_8BIT(four) (((four) << 4) | (four))
#define FIVE_TO_8BIT(five) (((five) << 3) | ((five) >> 2))
#define SIX_TO_8BIT(six) (((six) << 2) | ((six) >> 4))
#define HIGH_FOUR_TO_8BIT(four) (((four) & 0xF0) | ((four) >> 4))
#define LOW_FOUR_TO_8BIT(four) (((four) << 4) | ((four) & 0x0F))

//Vertex shader stuff
#define MI_GEO 0
#define MI_TEX(tex) ((tex) + 1)
//#define WV_XF_ADDRESS (vs.matrix_index[MI_GEO]*4)
//#define WV_MATRIX ((float*)&m.xf_mem[WV_XF_ADDRESS])
//#define NORMAL_XF_ADDRESS (0x400 + vs.matrix_index[MI_GEO]*3)
//#define NORMAL_MATRIX ((float*)&m.xf_mem[NORMAL_XF_ADDRESS])
#define NMATRICES 10

#define WV_XF_SIZE 12
#define IS_WVMATRIX_BASE(a) (((a) < NMATRICES*WV_XF_SIZE) && ((a)%WV_XF_SIZE == 0))
#define WV_MATRIX(n) ((float*)&m.xf_mem[n*WV_XF_SIZE])

#define TMAT_XF_SIZE 12
#define TMAT_XF_BASE 0x78
#define IS_TMATRIX_BASE(a) (((a) >= TMAT_XF_BASE) &&\
	((a) < TMAT_XF_BASE + NMATRICES*TMAT_XF_SIZE) &&\
	(((a)-TMAT_XF_BASE)%TMAT_XF_SIZE == 0))

#define NORMAL_XF_SIZE 9
#define NORMAL_XF_BASE 0x400
#define IS_NMATRIX_BASE(a) (((a) >= NORMAL_XF_BASE) &&\
	((a) < NORMAL_XF_BASE + NMATRICES*NORMAL_XF_SIZE) &&\
	(((a)-NORMAL_XF_BASE)%NORMAL_XF_SIZE == 0))
#define NORMAL_MATRIX(n) ((float*)&m.xf_mem[0x400 + n*NORMAL_XF_SIZE])

#define DUALTEX_XF_SIZE 12
#define DUALTEX_NMATRICES 21
#define DUALTEX_XF_BASE 0x504 //0x500
#define IS_DUALTEX_MATRIX_BASE(a) (((a) >= DUALTEX_XF_BASE) &&\
	((a) < DUALTEX_XF_BASE + DUALTEX_NMATRICES*DUALTEX_XF_SIZE) &&\
	(((a)-DUALTEX_XF_BASE)%DUALTEX_XF_SIZE == 0))

#define LIGHT_XF_SIZE 16
#define NLIGHTS 8
#define LIGHT_XF_BASE 0x600
#define IS_LIGHT_BASE(a) (((a) >= LIGHT_XF_BASE) &&\
	((a) < LIGHT_XF_BASE + NLIGHTS*LIGHT_XF_SIZE) &&\
	(((a)-LIGHT_XF_BASE)%LIGHT_XF_SIZE == 0))

//Vertex Shader registers (Vertex/Constant)
#define VSCM_PMATRIX 4	//I don't remember what the M stands for :}
#define VSCM_WV_N_MATRIX 3
#define VSCM_TMATRIX 3

#define VSCOFF_COLORS 1
#define VSC_AMBIENT(n) (VSCOFF_COLORS + (n)*2)
#define VSC_MATERIAL(n) (VSCOFF_COLORS + (n)*2 + 1)
#define VSCOFF_LIGHTS VSC_AMBIENT(2)  //there are 2 sets of color registers
#define VSC_LIGHTCOL(n) (VSCOFF_LIGHTS + (n)*5)
#define VSC_LIGHTGEO(n) (VSCOFF_LIGHTS + (n)*5 + 1)
#define VSCOFF_PMATRIX VSC_LIGHTCOL(8)	//there are 8 lights
#define VSC_PMATRIX(n) (VSCOFF_PMATRIX + (n)*VSCM_PMATRIX)
#define VSCOFF_NMATRIX (VSCOFF_PMATRIX + VSCM_PMATRIX*NMATRICES)
#define VSC_NMATRIX(n) (VSCOFF_NMATRIX + (n)*VSCM_WV_N_MATRIX)
#define VSCOFF_WVMATRIX (VSCOFF_NMATRIX + VSCM_WV_N_MATRIX*NMATRICES)
#define VSC_WVMATRIX(n) (VSCOFF_WVMATRIX + (n)*VSCM_WV_N_MATRIX)
#define VSCOFF_TMATRIX (VSCOFF_WVMATRIX + VSCM_WV_N_MATRIX*NMATRICES)
#define VSC_TMATRIX(n) (VSCOFF_TMATRIX + (n)*VSCM_TMATRIX)
#define VSCOFF_DTMATRIX (VSCOFF_TMATRIX + VSCM_TMATRIX*NMATRICES)
#define VSC_DTMATRIX(n) (VSCOFF_DTMATRIX + (n)*VSCM_TMATRIX)
#define VSC_END (VSCOFF_DTMATRIX + VSCM_TMATRIX*DUALTEX_NMATRICES)

enum GXDiffuseFn { GX_DF_NONE, GX_DF_SIGN, GX_DF_CLAMP };

//#define SHADER_BUFFER_SIZE 32*K
//the ugly ones!! :)
#define DO_LEVEL if(level > 0) { sstr << setw(level*2) << setfill(' ') << " "; }
#define SWRITE_NOLEVEL sstr <<
//#define SWRITE_NOLEVEL swrite(buffer, sptr,
#define SWRITE DO_LEVEL SWRITE_NOLEVEL

//void swrite(char *buffer, char *&sptr, const char *format, ...);

void fprintHTMLAsText(FILE *file, const char *html);
void fprintShader(FILE *file, const char *shader);
DWORD hash3(BYTE *k, DWORD length, DWORD initval);
string sprintCompArg(const char *sel, BYTE op);
string sprintCCompArg(const char *sel, BYTE op);
string sprintACompArg(const char *sel, BYTE op);
string sprintAFArg(BYTE comp, BYTE ref);

//TSS stuff
DWORD tevCSel2D3DTA(BYTE csel);
DWORD tevASel2D3DTA(BYTE asel);

//pixel shader constants
enum PSCReg { PSC_ZERO, PSC_ONE, /*add some Konstants here*/ PSCOFF_VARABLES_AREA };
#define PSCOFF_CREG PSCOFF_VARABLES_AREA
#define PSC_CREG(i) (PSCOFF_CREG+(i)) //CPREV,C0-C2
#define PSCOFF_KREG PSC_CREG(4)
#define PSC_KREG(i) (PSCOFF_KREG+(i)) //K0-K3
#define PSC_END PSC_KREG(4)

//Multi-register load flags (max 8 registers)
namespace mrl {
#define MRLTEMP(id) TEMP_##id,
#define MRLFINAL(id) ID_##id = 1 << (TEMP_##id),
#define MRLOR(id) ID_##id |
#define DECLARE_MRL(collection, name) enum { collection(MRLTEMP) KRAP_##collection };\
	enum { collection(MRLFINAL) KRAP2_##collection };\
	const BYTE name = (collection(MRLOR) 0)

#define MRL_TLUT(macro) macro(LOAD0) macro(LOAD1)
	DECLARE_MRL(MRL_TLUT, tlut);

#define MRL_TEVREG1(macro) macro(LOW) macro(HIGH)
	DECLARE_MRL(MRL_TEVREG1, tev);
};
#define CLEARLOAD(s) (s).load = 0
#define SETLOAD(s, id) (s).load |= mrl::ID_##id
#define ISLOADED(s) ((s).load == mrl::s)


struct FIELD {
	FIELD(DWORD a, const char *b, const char **c=NULL, size_t n=0)
		: d(a), name(b), strings(c), nstrings(n) {}
	DWORD d;
	const char *name;
	const char **strings;
	size_t nstrings;
};

class FieldCollection {
public:
	FieldCollection(const char *name) : n(name) {}
	void add(FIELD f) { vfield.push_back(f); }
	void dump() {
		bool error = false;
		GPDEGUB("%s:", n);
		for(size_t i=0; i<vfield.size(); i++) {
			FIELD f = vfield[i];
			GPDEGUB("%s %s ", (i==0) ? "" : " |", f.name);
			if(f.strings) {
				const char *string;
				if(f.d < f.nstrings)
					string = f.strings[f.d];
				else {
					string = TROGDOR;
					error = true;
				}
				GPDEGUB("%s(%i)", string, f.d);
			} else {
				GPDEGUB("%i", f.d);
			}
		}
		GPDEGUB("\n");
		if(error)
			throw hardware_fatal_exception("GP Invalid field value!");
	}
private:
	vector<FIELD> vfield;
	const char *n;
};

#define BEGIN_FIELDS(dahta, name) FieldCollection fc(name); DWORD fc_d = dahta;
#define END_FIELDS fc.dump();

#define FC_ASSIGN_MULTI(name, start, end) name = getbitsr(fc_d, start, end)
#define FC_ASSIGN_SINGLE(name, bit) name = getbitr(fc_d, bit)
#define FC_DECLARE_MULTI(name, start, end) DWORD FC_ASSIGN_MULTI(name, start, end)
#define FC_DECLARE_SINGLE(name, bit) bool FC_ASSIGN_SINGLE(name, bit)
#define FC_ADD_NOSTRINGS(name) fc.add(FIELD(name, #name))
#define FC_ADD_STRINGS(name, strings) fc.add(FIELD(name, #name, strings, sizeof(strings) / 4))
//Declare aNd Add
//Multi
#define DNAM(name, start, end) FC_DECLARE_MULTI(name, start, end);\
	FC_ADD_NOSTRINGS(name)
//Multi with Strings
#define DNAMS(name, start, end, strings) FC_DECLARE_MULTI(name, start, end);\
	FC_ADD_STRINGS(name, strings)
//Single
#define DNAS(name, bit)	FC_DECLARE_SINGLE(name, bit);\
	FC_ADD_NOSTRINGS(name)
//Single with Strings
#define DNASS(name, bit, strings) FC_DECLARE_SINGLE(name, bit);\
	FC_ADD_STRINGS(name, strings)
//Assign aNd Add
#define ANAM(name, start, end) FC_ASSIGN_MULTI(name, start, end);\
	FC_ADD_NOSTRINGS(name)
#define ANAMS(name, start, end, strings) FC_ASSIGN_MULTI(name, start, end);\
	FC_ADD_STRINGS(name, strings)
#define ANAS(name, bit)	FC_ASSIGN_SINGLE(name, bit);\
	FC_ADD_NOSTRINGS(name)
#define ANASS(name, bit, strings) FC_ASSIGN_SINGLE(name, bit);\
	FC_ADD_STRINGS(name, strings)

#define STRINGIZE_FIRST(id, sel) #id
#define STRINGIZE_SECOND(id, sel) #sel

//enumerations with strings
namespace gx {
#define GXLOGICOP(macro) macro(LO_CLEAR), macro(LO_AND), macro(LO_REVAND),\
	macro(LO_COPY), macro(LO_INVAND), macro(LO_NOOP), macro(LO_XOR), macro(LO_OR),\
	macro(LO_NOR), macro(LO_EQUIV), macro(LO_INV), macro(LO_REVOR), macro(LO_INVCOPY),\
	macro(LO_INVOR), macro(LO_NAND), macro(LO_SET)
	enum LogicOp { GXLOGICOP(NOTHING) };
	static const char *logicop[] = { GXLOGICOP(STRINGIZE) };

#define GXBLENDFACTOR(macro, gx, d3d)\
	macro(BF_ZERO, D3DBLEND_ZERO), macro(BF_ONE, D3DBLEND_ONE),\
	macro(BF_##gx##CLR, D3DBLEND_##d3d##COLOR),\
	macro(BF_INV##gx##CLR, D3DBLEND_INV##d3d##COLOR),\
	macro(BF_SRCALPHA, D3DBLEND_SRCALPHA), macro(BF_INVSRCALPHA, D3DBLEND_INVSRCALPHA),\
	macro(BF_DSTALPHA, D3DBLEND_DESTALPHA), macro(BF_INVDSTALPHA, D3DBLEND_INVDESTALPHA)
	static const char *src_blendfactor[] = { GXBLENDFACTOR(STRINGIZE_FIRST, SRC, SRC) };
	static const D3DBLEND src_d3d_blendfactor[] = { GXBLENDFACTOR(SECOND, SRC, SRC) };
	static const char *dst_blendfactor[] = { GXBLENDFACTOR(STRINGIZE_FIRST, DST, DEST) };
	static const D3DBLEND dst_d3d_blendfactor[] = { GXBLENDFACTOR(SECOND, DST, DEST) };

#define GXCOMPARE(macro) macro(C_NEVER, D3DCMP_NEVER), macro(C_LESS, D3DCMP_LESS),\
	macro(C_EQUAL, D3DCMP_EQUAL), macro(C_LEQUAL, D3DCMP_LESSEQUAL),\
	macro(C_GREATER, D3DCMP_GREATER), macro(C_NEQUAL, D3DCMP_NOTEQUAL),\
	macro(C_GEQUAL, D3DCMP_GREATEREQUAL), macro(C_ALWAYS, D3DCMP_ALWAYS)
	enum Compare { GXCOMPARE(FIRST) };
	static const char *comp[] = { GXCOMPARE(STRINGIZE_FIRST) };
	static const D3DCMPFUNC d3d_comp[] = { GXCOMPARE(SECOND) };

#define GXALPHAOP(macro) macro(AO_AND), macro(AO_OR), macro(AO_XOR), macro(AO_XNOR)
	enum AlphaOp { GXALPHAOP(NOTHING) };
	static const char *alphaop[] = { GXALPHAOP(STRINGIZE) };

#define TG_SOURCE(macro) macro(POS), macro(NORMAL), macro(COLOR), macro(BINORMAL),\
	macro(TANGENT), macro(TEX0), macro(TEX1), macro(TEX2), macro(TEX3), macro(TEX4),\
	macro(TEX5),  macro(TEX6), macro(TEX7)
#define TGS_MEH(meh) TGS_##meh
	enum TGSource { TG_SOURCE(TGS_MEH) };
	static const char *tg_source[] = { TG_SOURCE(STRINGIZE) };

#define TG_TYPE(macro) macro(REGULAR), macro(EMBOSS_MAP), macro(COLOR_STRGBC0),\
	macro(COLOR_STRGBC1)
#define TGT_MEH(meh) TGT_##meh
	enum TGType { TG_TYPE(TGT_MEH) };
	static const char *tg_type[] = { TG_TYPE(STRINGIZE) };

#define PERF_XF(std) std(NONE, 0) std(CLOCKS, 0x00000273) std(VERTICES, 0x0000014a)\
	std(CLIP_VTX, 0x0000016b) std(CLIP_CLKS, 0x00000084) std(XF_WAIT_IN, 0x000000c6)\
	std(XF_WAIT_OUT, 0x00000210) std(XF_XFRM_CLKS, 0x00000252) std(XF_LIT_CLKS, 0x00000231)\
	std(XF_BOT_CLKS, 0x000001ad) std(XF_REGLD_CLKS, 0x000001ce)\
	std(XF_REGRD_CLKS, 0x00000021) std(CLIP_RATIO, 0x00000153)
};

#define TEV_ENUM_FIRST(id, sel) id
#define TEV_ENUM_STD(id, sel) ,id
#define TEV_DEGUB_STD(id, sel) ,#id
#define TEV_SHADER_STD(id, sel) ,#sel

#define TEVKSELS(first, std, jmp) first(KSEL_1, 1) std(K7_8, 0.875) std(K3_4, 0.75)\
	std(KSEL_5_8, 0.625) std(KSEL_1_2, 0.5) std(KSEL_3_8, 0.375) std(KSEL_1_4, 0.25)\
	std(KSEL_1_8, 0.125) jmp(KSEL_K0, konst0) std(KSEL_K1, konst1) std(KSEL_K2, konst2)\
	std(KSEL_K3, konst3) std(KSEL_K0_R, konst0.r) std(KSEL_K1_R, konst1.r)\
	std(KSEL_K2_R, konst2.r) std(KSEL_K3_R, konst3.r) std(KSEL_K0_G, konst0.g)\
	std(KSEL_K1_G, konst1.g) std(KSEL_K2_G, konst2.g) std(KSEL_K3_G, konst3.g)\
	std(KSEL_K0_B, konst0.b) std(KSEL_K1_B, konst1.b) std(KSEL_K2_B, konst2.b)\
	std(KSEL_K3_B, konst3.b) std(KSEL_K0_A, konst0.a) std(KSEL_K1_A, konst1.a)\
	std(KSEL_K2_A, konst2.a) std(KSEL_K3_A, konst3.a)
#define TEVKSEL_ENUM_JMP(id, sel) ,id=0xC
enum TevKSel { TEVKSELS(TEV_ENUM_FIRST, TEV_ENUM_STD, TEVKSEL_ENUM_JMP) };
#define TEVKSEL_DEGUB_JMP(id, sel) ,TROGDOR, TROGDOR, TROGDOR, TROGDOR ,#id
static const char *s_tevksel_degub[] = {
	TEVKSELS(STRINGIZE_FIRST, TEV_DEGUB_STD, TEVKSEL_DEGUB_JMP)
};
#define TEVKSEL_SHADER_JMP(id, sel) ,NULL, NULL, NULL, NULL ,#sel
static const char *s_tevksel_shader[] = {
	TEVKSELS(STRINGIZE_SECOND, TEV_SHADER_STD, TEVKSEL_SHADER_JMP)
};

#define TEVCSELS(first, std) first(CC_CPREV, prev) std(CC_APREV, prev.a) std(CC_C0, c0)\
	std(CC_A0, c0.a) std(CC_C1, c1) std(CC_A1, c1.a) std(CC_C2, c2) std(CC_A2, c2.a)\
	std(CC_TEXC, textemp) std(CC_TEXA, textemp.a) std(CC_RASC, rastemp)\
	std(CC_RASA, rastemp.a) std(CC_ONE, 1) std(CC_HALF, 0.5) std(CC_KONST, konsttemp)\
	std(CC_ZERO, 0)
enum TevColorSel { TEVCSELS(TEV_ENUM_FIRST, TEV_ENUM_STD) };
static const char *s_tevcsel_degub[] =
{ TEVCSELS(STRINGIZE_FIRST, TEV_DEGUB_STD) };
static const char *s_tevcsel_shader[] =
{ TEVCSELS(STRINGIZE_SECOND, TEV_SHADER_STD) };

#define TEVASELS(first, std) first(CA_APREV, prev.a) std(CA_A0, c0.a) std(CA_A1, c1.a)\
	std(CA_A2, c2.a) std(CA_TEXA, textemp.a) std(CA_RASA, rastemp.a)\
	std(CA_KONST, konsttemp.a) std(CA_ZERO, 0)
enum TevAlphaSel { TEVASELS(TEV_ENUM_FIRST, TEV_ENUM_STD) };
static const char *s_tevasel_degub[] =
{ TEVASELS(STRINGIZE_FIRST, TEV_DEGUB_STD) };
static const char *s_tevasel_shader[] =
{ TEVASELS(STRINGIZE_SECOND, TEV_SHADER_STD) };

#define TEVBIASES(std) std(ZERO, +0), std(ADDHALF, +0.5), std(SUBHALF, -0.5),\
	std(TROGDOR, TROGDOR)
static const char *s_tevbias_degub[] = { TEVBIASES(STRINGIZE_FIRST) };
static const char *s_tevbias_shader[] = { TEVBIASES(STRINGIZE_SECOND) };
#define ISCOMP bias == 3

#define TEVSCALES(std) std(SCALE_1, *1), std(SCALE_2, *2),\
	std(SCALE_4, *4), std(DIVIDE_2, /2)
static const char *s_tevscale_degub[] = { TEVSCALES(STRINGIZE_FIRST) };
static const char *s_tevscale_shader[] = { TEVSCALES(STRINGIZE_SECOND) };

#define TEVCOMPS(std) std(R8_GT), std(R8_EQ), std(GR16_GT), std(GR16_EQ), std(BGR24_GT),\
	std(BGR24_EQ)
#define TEVCCOMPS(std) std(RGB8_GT), std(RGB8_EQ)
static const char *s_tevccomp_degub[] = { TEVCOMPS(STRINGIZE), TEVCCOMPS(STRINGIZE) };
//static const char *s_tevccomp_shader[] = { TEVCCOMPS(STRINGIZE) };

#define TEVACOMPS(std) std(A8_GT), std(A8_EQ)
static const char *s_tevacomp_degub[] = { TEVCOMPS(STRINGIZE), TEVACOMPS(STRINGIZE) };
//static const char *s_tevacomp_shader[] = { TEVACOMPS(STRINGIZE) };

#define TEVREGS(std) std(GX_TEVPREV, prev), std(GX_TEVREG0, c0), std(GX_TEVREG1, c1),\
	std(GX_TEVREG2, c2)
static const char *s_tevreg_degub[] = { TEVREGS(STRINGIZE_FIRST) };
static const char *s_tevreg_shader[] = { TEVREGS(STRINGIZE_SECOND) };

#define TEVCHANS(std) std(RED, r), std(GREEN, g), std(BLUE, b), std(ALPHA, a)
#define CHARIZE_SECOND(id, sel) #@sel
static const char *s_tevchan_degub[] = { TEVCHANS(STRINGIZE_FIRST) };
static const char s_tevchan_shader[] = { TEVCHANS(CHARIZE_SECOND) };

union XF_LOG {
	DWORD dword;
	struct {
		WORD length, base;
	};
};
void __fastcall xf_log_start(DWORD xf_log);
void __fastcall xf_log1(DWORD xf_log, DWORD d);
void __fastcall xf_log_main(DWORD xf_log, DWORD *data);
void __fastcall xf_log(DWORD xf_log, DWORD *data);

union XF_INDX_LOG {
	DWORD dword;
	struct {
		WORD index;
		union {
			WORD word2;
			struct {
				WORD base : 12;
				WORD length : 4;
			};
		};
	};
};
void __fastcall xf_indx_log_start(char name, DWORD xf_indx_log);
void __fastcall xf_indx_log(char name, DWORD xf_indx_log, DWORD *data);

inline void xf_dumpword(WORD base, DWORD d) {
	if(base < 0x1000) {
		DEGUB(" %.6g(0x%08X)", MAKE(float, d), d);
	} else {
		DEGUB(" 0x%08X", d);  //this may be float, too. make a bool array or something.
	}
}


class XFHandlerInterp {
public:
	static void call(GP *that, void (GP::*func)(DWORD), DWORD d) {
		(that->*func)(d);
	}
	static void call(GP *that, void (GP::*func)(const DWORD*), const DWORD *data) {
		(that->*func)(data);
	}
	static void call(GP *that, void (GP::*func)(DWORD,DWORD), DWORD index, DWORD d) {
		(that->*func)(index, d);
	}
	static void call(GP *that, void (GP::*func)(DWORD,const DWORD*), DWORD index,
		const DWORD *data) { (that->*func)(index, data); }

	static void call(GP *that, void (GP::*func)(DWORD,const float*), DWORD index,
		const float *data) { (that->*func)(index, data); }
	static void call(GP *that, void (GP::*func)(DWORD,const float*,bool), DWORD index,
		const float *data, bool b) { (that->*func)(index, data, b); }
	static void call_if(GP *that, bool cond, void (GP::*func)(DWORD,const float*),
		DWORD index, const float *data) { if(cond) (that->*func)(index, data); }
	static const bool degub = true;
};

extern DWORD s_xf_data[16];

#endif	//GP_INTERNAL_H
